///////////////////////////////////////////////////////////////////////////////
//
// Copyright (c) 2009 Maciej Brodowicz
//
// Distributed under the Boost Software License, Version 1.0. (See accompanying 
// file LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)
//
///////////////////////////////////////////////////////////////////////////////

#include <cstdlib>
#include "modbus.hh"


const uint8_t refmsg[] = {0xb, 3, 0, 0x2a, 0, 4, 0x65, 0x6b};
const int refsize = sizeof(refmsg)/sizeof(refmsg[0]);

template<typename T> inline T min(T a1, T a2) {return (a1 < a2? a1: a2);}


int main(int argc, char *argv)
{
  try
  {
    Modbus::Client<RTU> cl;

    

    int i, errc = 0;
    for (i = 0; i < req.bytes(); i++) printf("%02x ", req[i]);
    printf("\n");
    if (req.bytes() != refsize)
    {
      fprintf(stderr, "Request size (%d) differs from reference packet length (%d)\n", req.bytes(), refsize);
      errc++;
    }
    for (i = 0; i < min(req.bytes(), refsize); i++)
      if (req[i] != refmsg[i])
      {
	fprintf(stderr, "Request has value 0x%02x (expected 0x%02x) at byte offset %d\n", req[i], refmsg[i], i);
	errc++;
      }
    if (!errc)
    {
      std::cout << "\nTest PASSED.\n";
      return 0;
    }
  }
  catch (Error e)
  {
    std::cerr << e.message() << std::endl;
  }
  std::cerr << "\nTest FAILED.\n";
  return 1;
}
