///////////////////////////////////////////////////////////////////////////////
//
// Copyright (c) 2009 Maciej Brodowicz
//
// Distributed under the Boost Software License, Version 1.0. (See accompanying 
// file LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)
//
///////////////////////////////////////////////////////////////////////////////

#include <cstdio>
#include <cstdlib>
#include "yytypes.hh"


int main(int argc, char *argv[])
{
  if (argc < 2)
  {
    printf("No input files given!\n");
    exit(1);
  }
 
  try
  {
    for (int i = 1; i < argc; i++)
    {
      printf("\nTrying file \"%s\"...\n", argv[i]);
      yyin = fopen(argv[i], "r");
      if (!yyin)
      {
	printf("Error: cannot open \"%s\"\n", argv[i]);
	continue;
      }
      yyrestart(yyin);
      if (!yyparse()) printf("Parsing successful\n");
      else printf("Parsing failed\n");
    }
  }
  catch (Error e)
  {
    std::cerr << e.message() << std::endl;
  }

  return 0;
}
