///////////////////////////////////////////////////////////////////////////////
//
// Copyright (c) 2009 Maciej Brodowicz
//
// Distributed under the Boost Software License, Version 1.0. (See accompanying 
// file LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)
//
///////////////////////////////////////////////////////////////////////////////

#include <cstdlib>
#include <iostream>
#include <cstring>
#include "modbus.hh"


int main(int argc, char *argv[])
{
  const char *host = "192.168.7.101";
  int port = 10001;

  if ((argc < 3) || (argc > 5))
  {
    std::cerr << argv[0] << " needs at least two and up to four arguments:\n"
	      << "*  RS-485 station number\n"
	      << "*  number of register to read\n"
	      << "*  optional: server address (default: " << host << ")\n"
	      << "*  optional: server port (default: " << port << ")\n";
    exit(1);
  }
  int stnum = strtol(argv[1], 0, 0);
  int regnum = strtol(argv[2], 0, 0);
  if (argc > 3) host = argv[3];
  if (argc > 4) port = strtol(argv[4], 0, 0);

  using namespace Comm::Modbus;

  try
  {
    Client<RTU> client(host, port, PR300_NULL_FN, Comm::NET485_COMM_HEADER);
    std::cout << "Server connection established\n";
    client.setTimeout(2000000); // 2 second timeout
    Request<RTU> req(stnum, RD_HREGS);

    // build the request: register number, register count: 1
    req.put(regnum); req.put(2);

    // send the request and receive a reply
    client.send(&req);
    std::cout << "Request sent\n";

    Reply<RTU> *rep = client.recv();
    std::cout << "Reply received\n";

    if (rep->failed())
    {
      std::cerr << "Abnormal reply with error code " << rep->ecode << " ("
		<< ExcInfo[rep->ecode] << ")\n";
      exit(2);
    }

    uint16_t val;
    rep->get(val);
    std::cout << "Received value of register " << regnum 
	      << " from station " << stnum
	      << ": " << val << std::endl;
  }
  catch (Error e)
  {
    std::cerr << e.message() << std::endl;
  }
}
