///////////////////////////////////////////////////////////////////////////////
//
// Copyright (c) 2009 Maciej Brodowicz
//
// Distributed under the Boost Software License, Version 1.0. (See accompanying 
// file LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)
//
///////////////////////////////////////////////////////////////////////////////

#include <cstdlib>
#include <iostream>
#include "conf.hh"
#include "copy.hh"


uint8_t result[] = {0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08,
		    0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f,
		    0x70, 0x71, 0x72, 0x73, 0x74, 0x75, 0x76, 0x77,
		    0x63, 0x64, 0x65, 0x66,
		    0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17, 0x18,
		    0x19, 0x1a, 0x1b, 0x1c, 0x1d, 0x1e, 0x00, 0x1f,
		    0x70, 0x71, 0x72, 0x73, 0x74, 0x75, 0x76, 0x77,
		    0x63, 0x64, 0x65, 0x66};
uint8_t buf[100];
int cnt = 0;

typedef void (copyf_t)(uint8_t);
inline void bytecopy(uint8_t b) {buf[cnt++] = b;}

int main()
{
  float f = 4.213164176251233e+21;
  double d = 4.3339037370679829e+233;

  using namespace Comm;
  // word size: 1 byte
  Append<long long,1,copyf_t>(bytecopy).copy(0x0102030405060708LL);
  Append<int,1,copyf_t>(bytecopy).copy(0x090a0b0c);
  Append<short,1,copyf_t>(bytecopy).copy(0x0d0e);
  Append<char,1,copyf_t>(bytecopy).copy(0x0f);
  Append<double,1,copyf_t>(bytecopy).copy(d);
  Append<float,1,copyf_t>(bytecopy).copy(f);
  // word size: 2 bytes
  Append<long long,2,copyf_t>(bytecopy).copy(0x1112131415161718LL);
  Append<int,2,copyf_t>(bytecopy).copy(0x191a1b1c);
  Append<short,2,copyf_t>(bytecopy).copy(0x1d1e);
  Append<char,2,copyf_t>(bytecopy).copy(0x1f);
  Append<double,2,copyf_t>(bytecopy).copy(d);
  Append<float,2,copyf_t>(bytecopy).copy(f);

  for (int i = 0; i < cnt; i++) printf("%02x ", buf[i]);
  printf("\n");
  if (sizeof(result)/sizeof(result[0]) != cnt)
  {
    fprintf(stderr, "The length of target buffer is %d, should be %ld\n\nTest FAILED.\n",
	    cnt, sizeof(result)/sizeof(result[0]));
    exit(1);
  }

  int errc = 0;
  for (int i = 0; i < cnt; i++)
    if (result[i] != buf[i])
    {
      printf("Difference at byte %2d: 0x%02x (should be: 0x%02x)\n", i, result[i], buf[i]);
      ++errc;
    }
  if (errc)
  {
    fprintf(stderr, "\nTest FAILED.\n");
    exit(1);
  }
  printf("\nTest PASSED.\n");
  return 0;
}
