///////////////////////////////////////////////////////////////////////////////
//
// Copyright (c) 2008 Maciej Brodowicz
//
// Distributed under the Boost Software License, Version 1.0. (See accompanying 
// file LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)
//
///////////////////////////////////////////////////////////////////////////////

#include "modbus.hh"


namespace Comm
{
  namespace Modbus
  {
    template<> int Request<RTU>::itemsize()
    {
      if (ready)
	throw Error(PROTOCOL, "Modbus::Request::put", "appending to a finalized buffer");
      bool oldh = inhdr;
      if (inhdr)
      {
	int sz;
	// placeholder for the yet unknown count value
	if (ps->cntidx == seq)
	{
	  sz = ps->hdr.items[seq++];
	  buffer.insert(buffer.end(), sz, 0);
	}
	sz = ps->hdr.items[seq++];	
	// done with the header?
	if (ps->hdr.cnt <= seq) {inhdr = false; seq = 0;}
	return sz;
      }
      return ps->plunit;
    }

    template<> void Request<RTU>::finalize()
    {
      if (ready) return;
      if (inhdr)
	throw Error(PROTOCOL, "Modbus::Request::finalize", "incomplete request (truncated header)");

      // insert properly sized count value for the payload if required
      if (ps->cntidx)
      {
	uint16_t cnt = seq-ps->cntadj;
	int cntoffs = 0;
	// find byte offset for the count field
	for (int i = 0; i < ps->cntidx; i++) cntoffs += ps->hdr.items[i];
	if (ps->hdr.items[ps->cntidx] > 1) buffer[cntoffs++] = cnt >> 8;
	buffer[cntoffs] = cnt & 0xff;
      }
    
      // compute CRC of the packet
      uint16_t crc = crc16(&buffer[0], buffer.size(), 0xffff);
      // CRC byte order is reversed
      append<uint8_t>(crc & 0xff);
      append<uint8_t>(crc >> 8);
      ready = true;
    }
  }
}
