///////////////////////////////////////////////////////////////////////////////
//
// Copyright (c) 2008 Maciej Brodowicz
//
// Distributed under the Boost Software License, Version 1.0. (See accompanying 
// file LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)
//
///////////////////////////////////////////////////////////////////////////////

#ifndef _modbus_client_h
#define _modbus_client_h

namespace Comm
{
  namespace Modbus
  {
    // parameters
    //// client customization flags
    enum ClientFlag
    {
      PR300_NULL_FN = 1 << 0, // detect and skip over occasional zero function byte returned by Yokogawa meter

      CLIENT_NONE = 0
    };


    // classes
    template<Protocol P = RTU>
    class Client: public TCPClient
    {
      ClientFlag flags;
      int checksum;

    public:
      Client(ClientFlag cf = 0, TCPClientFlag tf = 0) : TCPClient(tf), flags(cf), checksum(P == RTU? RTU_INIT_CRC: ASCII_INIT_LRC) { }
      Client(const char *server, int port, ClientFlag cf = 0, TCPClientFlag tf = 0) : TCPClient(server, port, tf), flags(cf), checksum(P == RTU? RTU_INIT_CRC: ASCII_INIT_LRC) { }

      // override base client interface to compute checksums on the fly
      uint8_t get();
      void get(void *, int);
      // get 2-byte word
      inline uint16_t getw() {return (static_cast<uint16_t>(get())<<8)|get();}

      void send(Request<P> *); // send pre-assembled request
      Reply<P> *recv(); // receive complete reply

    protected:
      // to save some typing
      inline void setEntry(int i, const PktStruct& ps, Reply<P>& r)
      {
	switch (ps.hdr.items[i])
	{
	case 1:
	  r.header.b1 = get();
	  if (i == ps.cntidx) r.psize = r.header.b1+ps.cntadj;
	  break;
	case 2:
	  r.header.w1 = getw();
	  if (i == ps.cntidx) r.psize = r.header.w1+ps.cntadj;
	  break;
	default:
	  throw Error(PROTOCOL, "Modbus::Client::setEntry", "invalid header item size");
	}
      }

      bool validate();
    };


    // specializations
    template<> inline void Client<RTU>::send(Request<RTU> *r)
    {
      r->finalize();
      TCPClient::send(&((*r)[0]), r->bytes());
    }
    template<> uint8_t Client<RTU>::get();
    template<> void Client<RTU>::get(void *, int);
  }
}

#endif // _modbus_client_h
