///////////////////////////////////////////////////////////////////////////////
//
// Copyright (c) 2008 Maciej Brodowicz
//
// Distributed under the Boost Software License, Version 1.0. (See accompanying 
// file LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)
//
///////////////////////////////////////////////////////////////////////////////

#ifndef _conf_h
#define _conf_h

// for byte order macro
#include <cctype>
// for uintxx_t definitions
#include <stdint.h>


namespace Comm
{
  enum Endianness
  {
    LE = 1,
    BE = 2
  };

#if __BYTE_ORDER == __LITTLE_ENDIAN
  const Endianness MachineEndian = LE;
#else
  const Endianness MachineEndian = BE;
#endif


  // some prototypes we couldn't find a good place for
  extern uint16_t crc16(uint8_t *data, int len, uint16_t crc);
}

#endif // _conf_h
