///////////////////////////////////////////////////////////////////////////////
//
// Copyright (c) 2008-2010 Maciej Brodowicz
//
// Distributed under the Boost Software License, Version 1.0. (See accompanying 
// file LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)
//
///////////////////////////////////////////////////////////////////////////////

#ifndef _comm_error_h
#define _comm_error_h

#include "../include/error.hh"


namespace Comm
{
  // exception types
  enum ErrType
  {
    GENERIC = 0,
    NOCONNECT,
    PROTOCOL,
    TIMEOUT,
    CHECKSUM,
    CORRUPT,
    TRUNCATED
  };

  class CommCat
  {
    // communication exception categories
    static char const *ErrCat[];

  public:
    static char const *info(int t)
    {
      if (t >= GENERIC && t <= TRUNCATED)
	return ErrCat[t];
      else return "<invalid communication error category>";
    }
  };

  // base
  class Error: public ::Error<CommCat>
  {
  protected:
    std::string prefixloc(char const *loc)
    {
      std::string s("Comm");
      if (loc && loc[0]) {s += "::"; s += loc;}
      else s += " namespace";
      return s;
    }

  public:
    Error(ErrType et, const char *l, const char *msg = 0):
      ::Error<CommCat>(et, prefixloc(l).c_str(), msg) { }
  };
}

#endif // _comm_error_h
