///////////////////////////////////////////////////////////////////////////////
//
// Copyright (c) 2008 Maciej Brodowicz
//
// Distributed under the Boost Software License, Version 1.0. (See accompanying 
// file LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)
//
///////////////////////////////////////////////////////////////////////////////

#ifndef _client_h
#define _client_h

namespace Comm
{
  // tuning flags
  enum TCPClientFlag
  {
    NET485_COMM_HEADER = 1 << 0, // discard initial header from NET485
    
    TCPCLIENT_NONE = 0
  };

  // simple client communicating over TCP/IP sockets
  class TCPClient
  {
  private:
    static const int AVG_RECV_BUF = 32;

    char *recbuf;
    int bufsize, start, end;
    int sockid;
    long tmout;
    TCPClientFlag flags;

    void reloc();
    void initbuf();
    void growbuf(int);
    // for debugging
  
  public:
    void connect(const char *server, int port);
    void setTimeout(long microsec);
    void send(void *buf, int len);
    void recv(int bytes);
    void resync();
    void get(void *buf, int cnt);
    uint8_t get() {recv(1); return recbuf[start++];}

    TCPClient(TCPClientFlag fl = TCPCLIENT_NONE) : sockid(-1), flags(fl), tmout(0) {initbuf();}
    TCPClient(const char *server, int port, TCPClientFlag fl = TCPCLIENT_NONE) : tmout(0), flags(fl)
    {
      initbuf();
      connect(server, port);
    }
  };
}

#endif // _client_h
