#
# Copyright 2007 University of Padova, Department of Information Engineering.
# 
# These PER values for 802.11g PHY modes have been obtained using a 
# dedicated OFDM physical layer simulator by Matteo Trivellato.
# This simulator calculates the PER by averaging the performance of a
# complete OFDM system over different multipath channel realizations
# with fixed exponential delay profile.   
#
#

PER instproc loadPERTable80211gTrivellato {} {

    $self add Mode6Mb 128    -3.9991  1
    $self add Mode6Mb 128  -2.999  0.9994
    $self add Mode6Mb 128  -1.999  0.9244
    $self add Mode6Mb 128  -0.99983  0.5771
    $self add Mode6Mb 128  0.0018098  0.2472
    $self add Mode6Mb 128  1.0003  0.0955
    $self add Mode6Mb 128  2.0008  0.0383
    $self add Mode6Mb 128  2.9999  0.0176
    $self add Mode6Mb 128  4  0.0069
    $self add Mode6Mb 128  5.0013  0.0028
    $self add Mode6Mb 128  6.0001  0.001
    $self add Mode6Mb 128  7.0008  0.0008
    $self add Mode6Mb 128  8.0015  0.0002
    $self add Mode6Mb 128  9  0
    $self add Mode6Mb 128  10.0003  0
    $self add Mode6Mb 128  11.0003  0
    $self add Mode6Mb 128  12  0
    $self add Mode6Mb 128  13.0008  0
    $self add Mode6Mb 128  13.9998  0
    $self add Mode6Mb 128  15.0014  0
    $self add Mode6Mb 128  16.0009  0
    $self add Mode6Mb 128  17.0004  0
    $self add Mode6Mb 128  17.9996  0
    $self add Mode6Mb 128  19.0001  0
    $self add Mode6Mb 128  20.001  0
    $self add Mode6Mb 256  -3.9995  1
    $self add Mode6Mb 256  -3  1
    $self add Mode6Mb 256  -1.9999  0.9851
    $self add Mode6Mb 256  -0.99974  0.7254
    $self add Mode6Mb 256  0.00082885  0.3418
    $self add Mode6Mb 256  1.0013  0.1382
    $self add Mode6Mb 256  2.0004  0.0575
    $self add Mode6Mb 256  3.0005  0.0275
    $self add Mode6Mb 256  3.9993  0.0103
    $self add Mode6Mb 256  4.9993  0.0053
    $self add Mode6Mb 256  6  0.0012
    $self add Mode6Mb 256  6.9994  0.0008
    $self add Mode6Mb 256  7.9995  0.0004
    $self add Mode6Mb 256  8.9993  0
    $self add Mode6Mb 256  10.0015  0.0001
    $self add Mode6Mb 256  11.0011  0
    $self add Mode6Mb 256  11.9991  0
    $self add Mode6Mb 256  13.001  0
    $self add Mode6Mb 256  14.0002  0
    $self add Mode6Mb 256  15.0013  0
    $self add Mode6Mb 256  15.9988  0
    $self add Mode6Mb 256  17.0001  0
    $self add Mode6Mb 256  17.9995  0
    $self add Mode6Mb 256  19.002  0
    $self add Mode6Mb 256  20.0011  0
    $self add Mode6Mb 512  -3.9999  1
    $self add Mode6Mb 512  -3  1
    $self add Mode6Mb 512  -1.9996  0.9988
    $self add Mode6Mb 512  -0.99986  0.8642
    $self add Mode6Mb 512  -0.00015287  0.4682
    $self add Mode6Mb 512  1.0005  0.201
    $self add Mode6Mb 512  1.9995  0.0833
    $self add Mode6Mb 512  3.0012  0.0382
    $self add Mode6Mb 512  3.9997  0.0154
    $self add Mode6Mb 512  5.0001  0.0064
    $self add Mode6Mb 512  6.0001  0.0025
    $self add Mode6Mb 512  7.0008  0.001
    $self add Mode6Mb 512  7.9993  0.0006
    $self add Mode6Mb 512  9.0007  0.0001
    $self add Mode6Mb 512  9.9999  0.0001
    $self add Mode6Mb 512  11.0002  0
    $self add Mode6Mb 512  12.0001  0
    $self add Mode6Mb 512  13.0002  0
    $self add Mode6Mb 512  13.9998  0
    $self add Mode6Mb 512  15.0007  0
    $self add Mode6Mb 512  16.0001  0
    $self add Mode6Mb 512  16.9995  0
    $self add Mode6Mb 512  18.0005  0
    $self add Mode6Mb 512  19  0
    $self add Mode6Mb 512  20.0003  0
    $self add Mode6Mb 1024  -4.0004  1
    $self add Mode6Mb 1024  -2.9999  1
    $self add Mode6Mb 1024  -1.9994  1
    $self add Mode6Mb 1024  -1.0001  0.9492
    $self add Mode6Mb 1024  0.00018845  0.5974
    $self add Mode6Mb 1024  0.99988  0.2722
    $self add Mode6Mb 1024  2.0002  0.1162
    $self add Mode6Mb 1024  3  0.0495
    $self add Mode6Mb 1024  4  0.0223
    $self add Mode6Mb 1024  5.0003  0.0086
    $self add Mode6Mb 1024  5.9998  0.0026
    $self add Mode6Mb 1024  7.0001  0.001
    $self add Mode6Mb 1024  8.0004  0.0001
    $self add Mode6Mb 1024  8.9999  0
    $self add Mode6Mb 1024  9.9998  0
    $self add Mode6Mb 1024  11.0007  0
    $self add Mode6Mb 1024  11.9998  0
    $self add Mode6Mb 1024  12.9998  0
    $self add Mode6Mb 1024  14.0005  0
    $self add Mode6Mb 1024  15.0001  0
    $self add Mode6Mb 1024  15.9998  0
    $self add Mode6Mb 1024  17.0002  0
    $self add Mode6Mb 1024  18.0001  0
    $self add Mode6Mb 1024  19  0
    $self add Mode6Mb 1024  20.0001  0
    $self add Mode6Mb 1500  -4  1
    $self add Mode6Mb 1500  -3  1
    $self add Mode6Mb 1500  -1.9999  1
    $self add Mode6Mb 1500  -0.99995  0.9763
    $self add Mode6Mb 1500  5.6321e-05  0.6589
    $self add Mode6Mb 1500  1.0002  0.3202
    $self add Mode6Mb 1500  2.0003  0.1381
    $self add Mode6Mb 1500  3.0004  0.0632
    $self add Mode6Mb 1500  4.0001  0.0269
    $self add Mode6Mb 1500  5.0001  0.0126
    $self add Mode6Mb 1500  6.0002  0.0036
    $self add Mode6Mb 1500  7.0002  0.0016
    $self add Mode6Mb 1500  8.0001  0.0006
    $self add Mode6Mb 1500  8.9999  0.0003
    $self add Mode6Mb 1500  9.9999  0.0001
    $self add Mode6Mb 1500  10.9998  0
    $self add Mode6Mb 1500  11.9997  0
    $self add Mode6Mb 1500  12.9997  0
    $self add Mode6Mb 1500  13.9999  0
    $self add Mode6Mb 1500  14.9999  0
    $self add Mode6Mb 1500  15.9999  0
    $self add Mode6Mb 1500  17.0001  0
    $self add Mode6Mb 1500  18.0002  0
    $self add Mode6Mb 1500  19.0002  0
    $self add Mode6Mb 1500  20.0002  0
    $self add Mode9Mb 128  6.6558e-05  0.9986
    $self add Mode9Mb 128  1.0011  0.9323
    $self add Mode9Mb 128  2.0006  0.7135
    $self add Mode9Mb 128  3.0022  0.4562
    $self add Mode9Mb 128  4.0019  0.2701
    $self add Mode9Mb 128  5.0018  0.1538
    $self add Mode9Mb 128  6.0002  0.0831
    $self add Mode9Mb 128  7.0004  0.0445
    $self add Mode9Mb 128  8.0006  0.0235
    $self add Mode9Mb 128  9.001  0.0139
    $self add Mode9Mb 128  10.0005  0.0074
    $self add Mode9Mb 128  11.0004  0.0032
    $self add Mode9Mb 128  12.0003  0.0023
    $self add Mode9Mb 128  13.0011  0.0011
    $self add Mode9Mb 128  14.0003  0.0005
    $self add Mode9Mb 128  15.0002  0.0002
    $self add Mode9Mb 128  16.0023  0.0001
    $self add Mode9Mb 128  17.0019  0
    $self add Mode9Mb 128  18  0
    $self add Mode9Mb 128  19.0009  0
    $self add Mode9Mb 128  20.0001  0
    $self add Mode9Mb 256  0.0007086  1
    $self add Mode9Mb 256  0.99966  0.9791
    $self add Mode9Mb 256  1.9995  0.8139
    $self add Mode9Mb 256  3.0013  0.5599
    $self add Mode9Mb 256  4.0003  0.3427
    $self add Mode9Mb 256  5.0007  0.1966
    $self add Mode9Mb 256  5.9994  0.111
    $self add Mode9Mb 256  7.001  0.0625
    $self add Mode9Mb 256  8.0002  0.0356
    $self add Mode9Mb 256  8.9996  0.0193
    $self add Mode9Mb 256  10.0008  0.011
    $self add Mode9Mb 256  11.0007  0.0066
    $self add Mode9Mb 256  12.0003  0.003
    $self add Mode9Mb 256  13.0001  0.0011
    $self add Mode9Mb 256  14.0012  0.0003
    $self add Mode9Mb 256  15.0004  0.0003
    $self add Mode9Mb 256  16  0.0002
    $self add Mode9Mb 256  17.0007  0.0001
    $self add Mode9Mb 256  18.0002  0
    $self add Mode9Mb 256  19.0008  0.0001
    $self add Mode9Mb 256  20  0
    $self add Mode9Mb 512  0.00099192  1
    $self add Mode9Mb 512  1.0004  0.9961
    $self add Mode9Mb 512  2.0008  0.8892
    $self add Mode9Mb 512  3.0001  0.655
    $self add Mode9Mb 512  4.001  0.4173
    $self add Mode9Mb 512  4.9999  0.2482
    $self add Mode9Mb 512  6.0007  0.14
    $self add Mode9Mb 512  6.9999  0.0781
    $self add Mode9Mb 512  8.0001  0.0448
    $self add Mode9Mb 512  8.9993  0.0246
    $self add Mode9Mb 512  10.0001  0.0131
    $self add Mode9Mb 512  10.9992  0.0064
    $self add Mode9Mb 512  12.0005  0.0034
    $self add Mode9Mb 512  12.9991  0.0027
    $self add Mode9Mb 512  14.0007  0.0011
    $self add Mode9Mb 512  14.9991  0.0007
    $self add Mode9Mb 512  16.0004  0.0002
    $self add Mode9Mb 512  17  0.0001
    $self add Mode9Mb 512  18.0007  0
    $self add Mode9Mb 512  19.0008  0
    $self add Mode9Mb 512  20.0006  0
    $self add Mode9Mb 1024  0.00043675  1
    $self add Mode9Mb 1024  0.99987  0.9995
    $self add Mode9Mb 1024  2.0001  0.9414
    $self add Mode9Mb 1024  3.0002  0.7322
    $self add Mode9Mb 1024  4  0.4902
    $self add Mode9Mb 1024  4.9999  0.2963
    $self add Mode9Mb 1024  6.0003  0.169
    $self add Mode9Mb 1024  6.9999  0.0957
    $self add Mode9Mb 1024  8.0002  0.0516
    $self add Mode9Mb 1024  9.0004  0.0277
    $self add Mode9Mb 1024  10.0001  0.0153
    $self add Mode9Mb 1024  11.0002  0.0077
    $self add Mode9Mb 1024  12.0005  0.0038
    $self add Mode9Mb 1024  12.9998  0.0022
    $self add Mode9Mb 1024  14.0002  0.0008
    $self add Mode9Mb 1024  15.0001  0.0003
    $self add Mode9Mb 1024  15.9999  0
    $self add Mode9Mb 1024  17.0001  0.0001
    $self add Mode9Mb 1024  18.0006  0.0001
    $self add Mode9Mb 1024  18.9999  0
    $self add Mode9Mb 1024  20.0002  0
    $self add Mode9Mb 1500  3.1242e-05  1
    $self add Mode9Mb   1500  1.0002  1
    $self add Mode9Mb 1500  1.9999  0.966
    $self add Mode9Mb   1500  2.9999  0.7878
    $self add Mode9Mb 1500  4.0001  0.544
    $self add Mode9Mb 1500  5.0001  0.3262
    $self add Mode9Mb 1500  6  0.1906
    $self add Mode9Mb 1500  7.0002  0.1094
    $self add Mode9Mb 1500  8.0002  0.063
    $self add Mode9Mb 1500  8.9997  0.0367
    $self add Mode9Mb   1500  10.0004  0.0211
    $self add Mode9Mb   1500  11  0.0111
    $self add Mode9Mb   1500  12  0.0044
    $self add Mode9Mb   1500  13.0004  0.0029
    $self add Mode9Mb   1500  14.0002  0.0015
    $self add Mode9Mb   1500  14.9999  0.0006
    $self add Mode9Mb   1500  16.0001  0.0001
    $self add Mode9Mb   1500  17  0.0001
    $self add Mode9Mb   1500  17.9999  0
    $self add Mode9Mb   1500  19.0004  0
    $self add Mode9Mb   1500  20.0001  0
    $self add Mode12Mb   128  0.0003852  0.9996
    $self add Mode12Mb   128  1.0004  0.9166
    $self add Mode12Mb   128  2.0005  0.5587
    $self add Mode12Mb   128  3.0008  0.2393
    $self add Mode12Mb   128  3.9992  0.096
    $self add Mode12Mb   128  5.0013  0.0371
    $self add Mode12Mb   128  6.0011  0.0156
    $self add Mode12Mb   128  7.0013  0.0069
    $self add Mode12Mb   128  8.0001  0.0024
    $self add Mode12Mb   128  9.0008  0.0012
    $self add Mode12Mb   128  10.0038  0.0005
    $self add Mode12Mb   128  11.001  0.0003
    $self add Mode12Mb   128  12.0015  0
    $self add Mode12Mb   128  13.0011  0.0001
    $self add Mode12Mb   128  14.0007  0
    $self add Mode12Mb   128  15.0012  0
    $self add Mode12Mb   128  16.0006  0
    $self add Mode12Mb   128  17.0006  0
    $self add Mode12Mb   128  18.0012  0
    $self add Mode12Mb   128  19.0013  0
    $self add Mode12Mb   128  20.0016  0
    $self add Mode12Mb   256  -0.00059018  1
    $self add Mode12Mb   256  1.0004  0.9785
    $self add Mode12Mb   256  2.0019  0.7105
    $self add Mode12Mb   256  3.0006  0.3401
    $self add Mode12Mb   256  4.0011  0.1382
    $self add Mode12Mb   256  5.0001  0.0583
    $self add Mode12Mb   256  6.001  0.0238
    $self add Mode12Mb   256  6.9999  0.0099
    $self add Mode12Mb   256  8.0011  0.0044
    $self add Mode12Mb   256  9.0005  0.0015
    $self add Mode12Mb   256  10.0007  0.0004
    $self add Mode12Mb   256  11.0012  0.0006
    $self add Mode12Mb   256  11.9994  0.0002
    $self add Mode12Mb   256  13.0011  0.0002
    $self add Mode12Mb   256  14  0
    $self add Mode12Mb   256  14.9997  0
    $self add Mode12Mb   256  16.001  0
    $self add Mode12Mb   256  16.9994  0
    $self add Mode12Mb   256  18.0025  0
    $self add Mode12Mb   256  18.9999  0
    $self add Mode12Mb   256  20.0008  0
    $self add Mode12Mb   512  -0.00044165  1
    $self add Mode12Mb   512  0.99945  0.9986
    $self add Mode12Mb   512  2.0005  0.859
    $self add Mode12Mb   512  3.0007  0.4666
    $self add Mode12Mb   512  4.001  0.2001
    $self add Mode12Mb   512  5.0011  0.0865
    $self add Mode12Mb   512  6.0014  0.033
    $self add Mode12Mb   512  7.0013  0.0152
    $self add Mode12Mb   512  8.001  0.006
    $self add Mode12Mb   512  9.0002  0.0028
    $self add Mode12Mb   512  10.0002  0.0007
    $self add Mode12Mb   512  10.9998  0.0003
    $self add Mode12Mb   512  12.0006  0
    $self add Mode12Mb   512  12.9995  0
    $self add Mode12Mb   512  13.9997  0
    $self add Mode12Mb   512  14.9997  0
    $self add Mode12Mb   512  16.0004  0
    $self add Mode12Mb   512  17.0007  0
    $self add Mode12Mb   512  17.9996  0
    $self add Mode12Mb   512  18.9996  0
    $self add Mode12Mb   512  19.9994  0
    $self add Mode12Mb   1024  0.00012553  1
    $self add Mode12Mb   1024  1.0001  1
    $self add Mode12Mb   1024  1.9999  0.9493
    $self add Mode12Mb   1024  3.0003  0.6032
    $self add Mode12Mb   1024  3.9999  0.2769
    $self add Mode12Mb   1024  5.0006  0.1213
    $self add Mode12Mb   1024  6  0.057
    $self add Mode12Mb   1024  6.9996  0.0259
    $self add Mode12Mb   1024  8.0006  0.0121
    $self add Mode12Mb   1024  9.0004  0.0038
    $self add Mode12Mb   1024  10  0.0022
    $self add Mode12Mb   1024  10.9998  0.0003
    $self add Mode12Mb   1024  12.0005  0
    $self add Mode12Mb   1024  12.9994  0
    $self add Mode12Mb   1024  14.0009  0
    $self add Mode12Mb   1024  14.9999  0
    $self add Mode12Mb   1024  16.0001  0
    $self add Mode12Mb   1024  16.9999  0
    $self add Mode12Mb   1024  18.0009  0
    $self add Mode12Mb   1024  18.9993  0
    $self add Mode12Mb   1024  20.0009  0
    $self add Mode12Mb   1500  -0.00017076  1
    $self add Mode12Mb   1500  1.0003  1
    $self add Mode12Mb   1500  1.9997  0.9788
    $self add Mode12Mb   1500  3.0004  0.6837
    $self add Mode12Mb   1500  3.9998  0.3326
    $self add Mode12Mb   1500  5.0005  0.1483
    $self add Mode12Mb   1500  5.9996  0.068
    $self add Mode12Mb   1500  7.0007  0.0294
    $self add Mode12Mb   1500  7.9995  0.0133
    $self add Mode12Mb   1500  9.0008  0.0054
    $self add Mode12Mb   1500  9.9996  0.0025
    $self add Mode12Mb   1500  11.0006  0.0012
    $self add Mode12Mb   1500  11.9997  0.0003
    $self add Mode12Mb   1500  13.0005  0
    $self add Mode12Mb   1500  13.9999  0
    $self add Mode12Mb   1500  15.0004  0
    $self add Mode12Mb   1500  15.9999  0
    $self add Mode12Mb   1500  17.0002  0
    $self add Mode12Mb   1500  18  0
    $self add Mode12Mb   1500  19.0002  0
    $self add Mode12Mb   1500  20.0003  0
    $self add Mode18Mb   128  -0.00011298  1
    $self add Mode18Mb   128  1.0005  1
    $self add Mode18Mb   128  2.0016  1
    $self add Mode18Mb   128  3.003  0.9992
    $self add Mode18Mb   128  4.0033  0.9317
    $self add Mode18Mb   128  5.0021  0.7209
    $self add Mode18Mb   128  6  0.4628
    $self add Mode18Mb   128  7.001  0.2727
    $self add Mode18Mb   128  8.0023  0.1558
    $self add Mode18Mb   128  9.0015  0.0847
    $self add Mode18Mb   128  10.003  0.0445
    $self add Mode18Mb   128  10.9995  0.0251
    $self add Mode18Mb   128  11.9989  0.0125
    $self add Mode18Mb   128  13.0011  0.0065
    $self add Mode18Mb   128  14.0016  0.0034
    $self add Mode18Mb   128  15.0011  0.0019
    $self add Mode18Mb   128  16.0019  0.001
    $self add Mode18Mb   128  17.002  0.0005
    $self add Mode18Mb   128  18.0009  0.0001
    $self add Mode18Mb   128  19.0002  0
    $self add Mode18Mb   128  20.0017  0
    $self add Mode18Mb   256  0.00026396  1
    $self add Mode18Mb   256  1.0004  1
    $self add Mode18Mb   256  2.0006  1
    $self add Mode18Mb   256  3.0003  1
    $self add Mode18Mb   256  4.0018  0.9753
    $self add Mode18Mb   256  5.0013  0.801
    $self add Mode18Mb   256  6.0018  0.5455
    $self add Mode18Mb   256  7.0013  0.3315
    $self add Mode18Mb   256  8.0025  0.192
    $self add Mode18Mb   256  9.0008  0.1068
    $self add Mode18Mb   256  10.0007  0.059
    $self add Mode18Mb   256  11.0001  0.0306
    $self add Mode18Mb   256  12.0006  0.0175
    $self add Mode18Mb   256  13.002  0.0092
    $self add Mode18Mb   256  14.001  0.0051
    $self add Mode18Mb   256  15.0005  0.0019
    $self add Mode18Mb   256  15.9998  0.0011
    $self add Mode18Mb   256  17.0023  0.0005
    $self add Mode18Mb   256  18.0005  0.0002
    $self add Mode18Mb   256  19.0002  0
    $self add Mode18Mb   256  19.9997  0
    $self add Mode18Mb   512  -0.00026723  1
    $self add Mode18Mb   512  1.0009  1
    $self add Mode18Mb   512  2.0001  1
    $self add Mode18Mb   512  3.0001  1
    $self add Mode18Mb   512  4.0001  0.9943
    $self add Mode18Mb   512  5.0011  0.8905
    $self add Mode18Mb   512  6.0003  0.6448
    $self add Mode18Mb   512  7.0012  0.4205
    $self add Mode18Mb   512  7.9997  0.2476
    $self add Mode18Mb   512  8.9997  0.1444
    $self add Mode18Mb   512  10.0006  0.0799
    $self add Mode18Mb   512  11.0001  0.0447
    $self add Mode18Mb   512  12.0007  0.0252
    $self add Mode18Mb   512  13.0005  0.0139
    $self add Mode18Mb   512  13.9998  0.0076
    $self add Mode18Mb   512  15.001  0.0039
    $self add Mode18Mb   512  16.0004  0.0017
    $self add Mode18Mb   512  17.0011  0.0008
    $self add Mode18Mb   512  17.9996  0.0004
    $self add Mode18Mb   512  19.0008  0.0001
    $self add Mode18Mb   512  19.9999  0
    $self add Mode18Mb   1024  0.00084961  1
    $self add Mode18Mb   1024  0.99986  1
    $self add Mode18Mb   1024  2.0006  1
    $self add Mode18Mb   1024  2.9992  1
    $self add Mode18Mb   1024  4.0004  0.9996
    $self add Mode18Mb   1024  4.9991  0.9538
    $self add Mode18Mb   1024  6.0006  0.7538
    $self add Mode18Mb   1024  6.9992  0.506
    $self add Mode18Mb   1024  8.0006  0.3098
    $self add Mode18Mb   1024  8.9996  0.1825
    $self add Mode18Mb   1024  10.0008  0.1031
    $self add Mode18Mb   1024  10.9996  0.0569
    $self add Mode18Mb   1024  12.0004  0.0286
    $self add Mode18Mb   1024  13.0009  0.0149
    $self add Mode18Mb   1024  14.0004  0.0086
    $self add Mode18Mb   1024  15.001  0.0039
    $self add Mode18Mb   1024  16.0003  0.0018
    $self add Mode18Mb   1024  17.0009  0.0005
    $self add Mode18Mb   1024  18.0004  0.0005
    $self add Mode18Mb   1024  19.0009  0.0001
    $self add Mode18Mb   1024  19.9998  0
    $self add Mode18Mb   1500  0.0005211  1
    $self add Mode18Mb   1500  1.0002  1
    $self add Mode18Mb   1500  2  1
    $self add Mode18Mb   1500  2.9999  1
    $self add Mode18Mb   1500  4.0004  1
    $self add Mode18Mb   1500  5.0002  0.9678
    $self add Mode18Mb   1500  6.0001  0.7909
    $self add Mode18Mb   1500  7.0001  0.5493
    $self add Mode18Mb   1500  8.0006  0.3429
    $self add Mode18Mb   1500  8.9999  0.2051
    $self add Mode18Mb   1500  10.0005  0.1146
    $self add Mode18Mb   1500  10.9999  0.0666
    $self add Mode18Mb   1500  12.0004  0.0389
    $self add Mode18Mb   1500  13.0001  0.0207
    $self add Mode18Mb   1500  14.0002  0.0111
    $self add Mode18Mb   1500  14.9999  0.0067
    $self add Mode18Mb   1500  16.0003  0.0035
    $self add Mode18Mb   1500  17.0003  0.0018
    $self add Mode18Mb   1500  18.0001  0.0008
    $self add Mode18Mb   1500  19.0002  0.0002
    $self add Mode18Mb   1500  20.0003  0
    $self add Mode24Mb   128  0.0011255  1
    $self add Mode24Mb   128  1.0029  1
    $self add Mode24Mb   128  2.0029  1
    $self add Mode24Mb   128  3.0018  1
    $self add Mode24Mb   128  4.0011  1
    $self add Mode24Mb   128  5.0019  0.9998
    $self add Mode24Mb   128  5.9994  0.9579
    $self add Mode24Mb   128  7.0011  0.6996
    $self add Mode24Mb   128  8.0004  0.3548
    $self add Mode24Mb   128  9.0031  0.1444
    $self add Mode24Mb   128  10.0004  0.0575
    $self add Mode24Mb   128  11.0017  0.0183
    $self add Mode24Mb   128  12.0021  0.0086
    $self add Mode24Mb   128  13.0012  0.0038
    $self add Mode24Mb   128  14.001  0.0012
    $self add Mode24Mb   128  15.0003  0.0006
    $self add Mode24Mb   128  16.0016  0.0002
    $self add Mode24Mb   128  17.001  0
    $self add Mode24Mb   128  18.0011  0.0001
    $self add Mode24Mb   128  19.0026  0
    $self add Mode24Mb   128  20.0013  0
    $self add Mode24Mb   256  0.001952  1
    $self add Mode24Mb   256  1  1
    $self add Mode24Mb   256  2.0009  1
    $self add Mode24Mb   256  3.0014  1
    $self add Mode24Mb   256  4.0004  1
    $self add Mode24Mb   256  5.0005  1
    $self add Mode24Mb   256  6.0009  0.9947
    $self add Mode24Mb   256  7.0018  0.8544
    $self add Mode24Mb   256  8.0021  0.5024
    $self add Mode24Mb   256  9.0007  0.2172
    $self add Mode24Mb   256  10.0001  0.0908
    $self add Mode24Mb   256  11.0014  0.0329
    $self add Mode24Mb   256  12.0004  0.0139
    $self add Mode24Mb   256  12.9995  0.0058
    $self add Mode24Mb   256  14.001  0.0016
    $self add Mode24Mb   256  15.0005  0.0013
    $self add Mode24Mb   256  16.0021  0.0004
    $self add Mode24Mb   256  16.9998  0
    $self add Mode24Mb   256  18.0009  0
    $self add Mode24Mb   256  19.0032  0
    $self add Mode24Mb   256  20.0013  0
    $self add Mode24Mb   512  0.00058724  1
    $self add Mode24Mb   512  1.001  1
    $self add Mode24Mb   512  2  1
    $self add Mode24Mb   512  3.0015  1
    $self add Mode24Mb   512  3.9996  1
    $self add Mode24Mb   512  5.0015  1
    $self add Mode24Mb   512  6.0001  0.9997
    $self add Mode24Mb   512  7.0014  0.9517
    $self add Mode24Mb   512  8.0004  0.6572
    $self add Mode24Mb   512  9.0001  0.3277
    $self add Mode24Mb   512  10.0009  0.1406
    $self add Mode24Mb   512  11.0002  0.0599
    $self add Mode24Mb   512  12.0005  0.0247
    $self add Mode24Mb   512  12.9993  0.0094
    $self add Mode24Mb   512  14.0011  0.0038
    $self add Mode24Mb   512  15.0003  0.0021
    $self add Mode24Mb   512  16.0004  0.0007
    $self add Mode24Mb   512  17.0011  0.0006
    $self add Mode24Mb   512  18.0002  0.0002
    $self add Mode24Mb   512  19.0007  0.0002
    $self add Mode24Mb   512  20.0008  0.0001
    $self add Mode24Mb   1024  0.0002247  1
    $self add Mode24Mb   1024  1.0007  1
    $self add Mode24Mb   1024  2.0011  1
    $self add Mode24Mb   1024  3.0013  1
    $self add Mode24Mb   1024  4.0016  1
    $self add Mode24Mb   1024  5.0016  1
    $self add Mode24Mb   1024  6.0008  1
    $self add Mode24Mb   1024  7.0002  0.9898
    $self add Mode24Mb   1024  8.0001  0.8021
    $self add Mode24Mb   1024  9.0004  0.435
    $self add Mode24Mb   1024  10.0003  0.1953
    $self add Mode24Mb   1024  10.9996  0.0813
    $self add Mode24Mb   1024  12.0003  0.0358
    $self add Mode24Mb   1024  13.0002  0.0164
    $self add Mode24Mb   1024  14.0004  0.0055
    $self add Mode24Mb   1024  15.0006  0.0026
    $self add Mode24Mb   1024  15.9999  0.0007
    $self add Mode24Mb   1024  17.0001  0.0004
    $self add Mode24Mb   1024  17.9993  0.0002
    $self add Mode24Mb   1024  18.9998  0.0001
    $self add Mode24Mb   1024  19.9999  0.0001
    $self add Mode24Mb   1500  -0.00036245  1
    $self add Mode24Mb   1500  1.0006  1
    $self add Mode24Mb   1500  2.0002  1
    $self add Mode24Mb   1500  2.9997  1
    $self add Mode24Mb   1500  4.0001  1
    $self add Mode24Mb   1500  5.0001  1
    $self add Mode24Mb   1500  6.0008  1
    $self add Mode24Mb   1500  7.0004  0.9976
    $self add Mode24Mb   1500  7.9996  0.8695
    $self add Mode24Mb   1500  9.0002  0.5126
    $self add Mode24Mb   1500  10.0005  0.2319
    $self add Mode24Mb   1500  11.0002  0.0998
    $self add Mode24Mb   1500  11.9999  0.0412
    $self add Mode24Mb   1500  12.9996  0.0174
    $self add Mode24Mb   1500  14.0006  0.0083
    $self add Mode24Mb   1500  15.0005  0.0038
    $self add Mode24Mb   1500  15.9998  0.0022
    $self add Mode24Mb   1500  17.0002  0.0004
    $self add Mode24Mb   1500  18.0001  0.0002
    $self add Mode24Mb   1500  19.0007  0.0002
    $self add Mode24Mb   1500  20.0001  0
    $self add Mode36Mb   128  0.0010588  1
    $self add Mode36Mb   128  1.0026  1
    $self add Mode36Mb   128  2.0037  1
    $self add Mode36Mb   128  3.0012  1
    $self add Mode36Mb   128  4.0034  1
    $self add Mode36Mb   128  5.0023  1
    $self add Mode36Mb   128  6.0011  1
    $self add Mode36Mb   128  7.001  1
    $self add Mode36Mb   128  8.0027  1
    $self add Mode36Mb   128  9.0028  0.9969
    $self add Mode36Mb   128  10.0027  0.9218
    $self add Mode36Mb   128  11.0013  0.6911
    $self add Mode36Mb   128  12.0021  0.4422
    $self add Mode36Mb   128  13.0025  0.2565
    $self add Mode36Mb   128  14.0023  0.1404
    $self add Mode36Mb   128  15.0002  0.0753
    $self add Mode36Mb   128  16.0011  0.0408
    $self add Mode36Mb   128  17.0015  0.0217
    $self add Mode36Mb   128  18.0011  0.0125
    $self add Mode36Mb   128  19.0011  0.0059
    $self add Mode36Mb   128  20.0038  0.0034
    $self add Mode36Mb   128  21.0014  0.0011
    $self add Mode36Mb   128  22.0032  0.0007
    $self add Mode36Mb   128  23.0003  0.0002
    $self add Mode36Mb   128  24.0038  0.0002
    $self add Mode36Mb   128  25.0025  0.0001
    $self add Mode36Mb   256  0.0017798  1
    $self add Mode36Mb   256  1.0006  1
    $self add Mode36Mb   256  2.002  1
    $self add Mode36Mb   256  3.0004  1
    $self add Mode36Mb   256  4.002  1
    $self add Mode36Mb   256  5.0014  1
    $self add Mode36Mb   256  6.0012  1
    $self add Mode36Mb   256  7.0017  1
    $self add Mode36Mb   256  8.0011  1
    $self add Mode36Mb   256  9.0027  1
    $self add Mode36Mb   256  10.0015  0.9765
    $self add Mode36Mb   256  11.001  0.8127
    $self add Mode36Mb   256  12.003  0.5538
    $self add Mode36Mb   256  13.001  0.3361
    $self add Mode36Mb   256  14.0016  0.197
    $self add Mode36Mb   256  15.004  0.1007
    $self add Mode36Mb   256  15.9997  0.0595
    $self add Mode36Mb   256  17.002  0.0327
    $self add Mode36Mb   256  18.0013  0.0165
    $self add Mode36Mb   256  19.002  0.0098
    $self add Mode36Mb   256  20.0015  0.0054
    $self add Mode36Mb   256  21.0027  0.0018
    $self add Mode36Mb   256  22.0016  0.0013
    $self add Mode36Mb   256  23.0041  0.0003
    $self add Mode36Mb   256  24.0008  0.0004
    $self add Mode36Mb   256  2.5  0
    $self add Mode36Mb   512  0.00044442  1
    $self add Mode36Mb   512  1.0015  1
    $self add Mode36Mb   512  2.0022  1
    $self add Mode36Mb   512  3.0015  1
    $self add Mode36Mb   512  4.0003  1
    $self add Mode36Mb   512  5.0004  1
    $self add Mode36Mb   512  6.0001  1
    $self add Mode36Mb   512  7.0016  1
    $self add Mode36Mb   512  8.0013  1
    $self add Mode36Mb   512  9.0002  1
    $self add Mode36Mb   512  10.0005  0.9963
    $self add Mode36Mb   512  11.0001  0.8962
    $self add Mode36Mb   512  12.001  0.6585
    $self add Mode36Mb   512  13.0006  0.426
    $self add Mode36Mb   512  14.0003  0.2508
    $self add Mode36Mb   512  15.001  0.1452
    $self add Mode36Mb   512  16.0007  0.0833
    $self add Mode36Mb   512  16.9996  0.0459
    $self add Mode36Mb   512  17.9989  0.0271
    $self add Mode36Mb   512  18.9994  0.0143
    $self add Mode36Mb   512  20.0004  0.008
    $self add Mode36Mb   512  21.0004  0.0028
    $self add Mode36Mb   512  22.001  0.0013
    $self add Mode36Mb   512  22.9991  0.0004
    $self add Mode36Mb   512  23.9999  0.0003
    $self add Mode36Mb   512  24.999  0.0002
    $self add Mode36Mb   1024  0.00089597  1
    $self add Mode36Mb   1024  1.0003  1
    $self add Mode36Mb   1024  2.0004  1
    $self add Mode36Mb   1024  3.0012  1
    $self add Mode36Mb   1024  4.0006  1
    $self add Mode36Mb   1024  5.0006  1
    $self add Mode36Mb   1024  6.0007  1
    $self add Mode36Mb   1024  7.0001  1
    $self add Mode36Mb   1024  8.0007  1
    $self add Mode36Mb   1024  9.0004  1
    $self add Mode36Mb   1024  10.0008  0.9996
    $self add Mode36Mb   1024  11.0003  0.9516
    $self add Mode36Mb   1024  11.9997  0.746
    $self add Mode36Mb   1024  13.0009  0.5037
    $self add Mode36Mb   1024  14.0004  0.3109
    $self add Mode36Mb   1024  15.0014  0.1805
    $self add Mode36Mb   1024  15.9995  0.1022
    $self add Mode36Mb   1024  17.0007  0.0569
    $self add Mode36Mb   1024  18.0003  0.0329
    $self add Mode36Mb   1024  19.0001  0.0181
    $self add Mode36Mb   1024  20.001  0.0109
    $self add Mode36Mb   1024  21.0003  0.0044
    $self add Mode36Mb   1024  22.0016  0.0025
    $self add Mode36Mb   1024  23.0009  0.0014
    $self add Mode36Mb   1024  24.0006  0.0012
    $self add Mode36Mb   1024  25.0016  0.0002
    $self add Mode36Mb   1500  -7.6938e-05  1
    $self add Mode36Mb   1500  1.0002  1
    $self add Mode36Mb   1500  1.9996  1
    $self add Mode36Mb   1500  3.001  1
    $self add Mode36Mb   1500  3.9998  1
    $self add Mode36Mb   1500  5.0003  1
    $self add Mode36Mb   1500  5.9998  1
    $self add Mode36Mb   1500  7.0003  1
    $self add Mode36Mb   1500  8.0004  1
    $self add Mode36Mb   1500  8.9999  1
    $self add Mode36Mb   1500  10.0003  1
    $self add Mode36Mb   1500  10.9997  0.9783
    $self add Mode36Mb   1500  12.0009  0.8115
    $self add Mode36Mb   1500  12.9998  0.5723
    $self add Mode36Mb   1500  14.0003  0.3626
    $self add Mode36Mb   1500  15.0012  0.2146
    $self add Mode36Mb   1500  16.0004  0.1215
    $self add Mode36Mb   1500  17.0007  0.0697
    $self add Mode36Mb   1500  18.0003  0.0394
    $self add Mode36Mb   1500  19  0.0215
    $self add Mode36Mb   1500  20.0003  0.01
    $self add Mode36Mb   1500  20.9999  0.0049
    $self add Mode36Mb   1500  22.0001  0.0019
    $self add Mode36Mb   1500  23.0003  0.0008
    $self add Mode36Mb   1500  24.0003  0.0005
    $self add Mode36Mb   1500  24.9999  0.0003
    $self add Mode48Mb   128  0.0024525  1
    $self add Mode48Mb   128  1.0026  1
    $self add Mode48Mb   128  2.005  1
    $self add Mode48Mb   128  3.002  1
    $self add Mode48Mb   128  4.003  1
    $self add Mode48Mb   128  5.0015  1
    $self add Mode48Mb   128  6.0027  1
    $self add Mode48Mb   128  7.0016  1
    $self add Mode48Mb   128  8.0046  1
    $self add Mode48Mb   128  9.0049  1
    $self add Mode48Mb   128  10.0015  1
    $self add Mode48Mb   128  11.0014  1
    $self add Mode48Mb   128  12.003  0.9998
    $self add Mode48Mb   128  13.0022  0.9799
    $self add Mode48Mb   128  14.0018  0.7991
    $self add Mode48Mb   128  15.0001  0.481
    $self add Mode48Mb   128  16.0034  0.2287
    $self add Mode48Mb   128  17.0039  0.1013
    $self add Mode48Mb   128  18.0011  0.0435
    $self add Mode48Mb   128  19.0035  0.0171
    $self add Mode48Mb   128  19.9993  0.0071
    $self add Mode48Mb   128  21.0032  0.0028
    $self add Mode48Mb   128  22.0026  0.0013
    $self add Mode48Mb   128  23.0012  0.0002
    $self add Mode48Mb   128  24.0043  0.0002
    $self add Mode48Mb   128  25.0014  0.0001
    $self add Mode48Mb   256  0.0034925  1
    $self add Mode48Mb   256  1.0026  1
    $self add Mode48Mb   256  2.0029  1
    $self add Mode48Mb   256  3.0014  1
    $self add Mode48Mb   256  4.0041  1
    $self add Mode48Mb   256  5.0022  1
    $self add Mode48Mb   256  6.002  1
    $self add Mode48Mb   256  7.0015  1
    $self add Mode48Mb   256  8.001  1
    $self add Mode48Mb   256  9.0012  1
    $self add Mode48Mb   256  10  1
    $self add Mode48Mb   256  11.0024  1
    $self add Mode48Mb   256  11.9991  1
    $self add Mode48Mb   256  13.0032  0.9981
    $self add Mode48Mb   256  13.9991  0.9243
    $self add Mode48Mb   256  15.0018  0.6452
    $self add Mode48Mb   256  16.0025  0.3357
    $self add Mode48Mb   256  17.0038  0.1546
    $self add Mode48Mb   256  17.9995  0.0667
    $self add Mode48Mb   256  19.0002  0.0271
    $self add Mode48Mb   256  20.0014  0.0122
    $self add Mode48Mb   256  21.0022  0.0051
    $self add Mode48Mb   256  22.0041  0.0027
    $self add Mode48Mb   256  23.0019  0.0008
    $self add Mode48Mb   256  24.0013  0.0004
    $self add Mode48Mb   256  25.0039  0.0002
    $self add Mode48Mb   512  0.0016187  1
    $self add Mode48Mb   512  1.001  1
    $self add Mode48Mb   512  2.0025  1
    $self add Mode48Mb   512  3.0006  1
    $self add Mode48Mb   512  4.0012  1
    $self add Mode48Mb   512  4.9993  1
    $self add Mode48Mb   512  6.0014  1
    $self add Mode48Mb   512  7.0001  1
    $self add Mode48Mb   512  8.0002  1
    $self add Mode48Mb   512  9.0001  1
    $self add Mode48Mb   512  10.0024  1
    $self add Mode48Mb   512  11.0015  1
    $self add Mode48Mb   512  12.0005  1
    $self add Mode48Mb   512  13.0012  1
    $self add Mode48Mb   512  14.0023  0.9828
    $self add Mode48Mb   512  15.0018  0.7958
    $self add Mode48Mb   512  16.0011  0.4605
    $self add Mode48Mb   512  17.0023  0.2222
    $self add Mode48Mb   512  18.0002  0.0956
    $self add Mode48Mb   512  19.0001  0.0408
    $self add Mode48Mb   512  20.0003  0.0169
    $self add Mode48Mb   512  20.9999  0.0079
    $self add Mode48Mb   512  21.9999  0.0036
    $self add Mode48Mb   512  23.0014  0.0016
    $self add Mode48Mb   512  24.0003  0.0006
    $self add Mode48Mb   512  24.9996  0.0002
    $self add Mode48Mb   1024  0.001367  1
    $self add Mode48Mb   1024  1.0003  1
    $self add Mode48Mb   1024  2.0004  1
    $self add Mode48Mb   1024  3.0006  1
    $self add Mode48Mb   1024  3.999  1
    $self add Mode48Mb   1024  5.0008  1
    $self add Mode48Mb   1024  6.0003  1
    $self add Mode48Mb   1024  6.9999  1
    $self add Mode48Mb   1024  8.0001  1
    $self add Mode48Mb   1024  9.001  1
    $self add Mode48Mb   1024  10.0014  1
    $self add Mode48Mb   1024  11.0001  1
    $self add Mode48Mb   1024  12.0011  1
    $self add Mode48Mb   1024  13.0009  1
    $self add Mode48Mb   1024  14  0.9977
    $self add Mode48Mb   1024  15.001  0.9004
    $self add Mode48Mb   1024  16.0007  0.5926
    $self add Mode48Mb   1024  17.0017  0.2999
    $self add Mode48Mb   1024  17.9999  0.1373
    $self add Mode48Mb   1024  19.001  0.0616
    $self add Mode48Mb   1024  19.9999  0.0277
    $self add Mode48Mb   1024  21.001  0.0127
    $self add Mode48Mb   1024  22.0009  0.0062
    $self add Mode48Mb   1024  22.9998  0.0034
    $self add Mode48Mb   1024  24.0014  0.0013
    $self add Mode48Mb   1024  25.0001  0.0007
    $self add Mode48Mb   1500  0.0002048  1
    $self add Mode48Mb   1500  1.0004  1
    $self add Mode48Mb   1500  2.0004  1
    $self add Mode48Mb   1500  3.0006  1
    $self add Mode48Mb   1500  4.0004  1
    $self add Mode48Mb   1500  5.0005  1
    $self add Mode48Mb   1500  6.0007  1
    $self add Mode48Mb   1500  7.0007  1
    $self add Mode48Mb   1500  8.0006  1
    $self add Mode48Mb   1500  9.0005  1
    $self add Mode48Mb   1500  10.0007  1
    $self add Mode48Mb   1500  11.0002  1
    $self add Mode48Mb   1500  11.9996  1
    $self add Mode48Mb   1500  13.0002  1
    $self add Mode48Mb   1500  13.9998  0.9998
    $self add Mode48Mb   1500  14.9995  0.9327
    $self add Mode48Mb   1500  15.9998  0.657
    $self add Mode48Mb   1500  17.0006  0.3481
    $self add Mode48Mb   1500  18.0003  0.1599
    $self add Mode48Mb   1500  19.0008  0.0687
    $self add Mode48Mb   1500  20.0006  0.0329
    $self add Mode48Mb   1500  20.9994  0.0146
    $self add Mode48Mb   1500  22.0006  0.0064
    $self add Mode48Mb   1500  23.0008  0.0025
    $self add Mode48Mb   1500  23.9991  0.0012
    $self add Mode48Mb   1500  25.001  0.0009
    $self add Mode54Mb   128  0.0024085  1
    $self add Mode54Mb   128  1.0011  1
    $self add Mode54Mb   128  2.0007  1
    $self add Mode54Mb   128  3.0056  1
    $self add Mode54Mb   128  4.0045  1
    $self add Mode54Mb   128  5.0039  1
    $self add Mode54Mb   128  6.002  1
    $self add Mode54Mb   128  7.0033  1
    $self add Mode54Mb   128  8.0056  1
    $self add Mode54Mb   128  9.0004  1
    $self add Mode54Mb   128  10.0026  1
    $self add Mode54Mb   128  11.0024  1
    $self add Mode54Mb   128  12.0017  1
    $self add Mode54Mb   128  13.0045  1
    $self add Mode54Mb   128  14.0037  0.9969
    $self add Mode54Mb   128  15.0021  0.9337
    $self add Mode54Mb   128  16.0015  0.7118
    $self add Mode54Mb   128  17.0035  0.4556
    $self add Mode54Mb   128  18.0024  0.2553
    $self add Mode54Mb   128  19.0046  0.1355
    $self add Mode54Mb   128  20.002  0.0733
    $self add Mode54Mb   128  21.0036  0.0371
    $self add Mode54Mb   128  22.0015  0.019
    $self add Mode54Mb   128  23.0029  0.0088
    $self add Mode54Mb   128  24.0029  0.0062
    $self add Mode54Mb   128  25.0025  0.0023
    $self add Mode54Mb   128  26.0036  0.0013
    $self add Mode54Mb   128  27.0015  0.0006
    $self add Mode54Mb   128  28.0029  0.0005
    $self add Mode54Mb   128  29.0029  0.0004
    $self add Mode54Mb   128  30.0025  0
    $self add Mode54Mb   256  0.0011185  1
    $self add Mode54Mb   256  1.0005  1
    $self add Mode54Mb   256  2.0009  1
    $self add Mode54Mb   256  3.0024  1
    $self add Mode54Mb   256  4.0034  1
    $self add Mode54Mb   256  5.0016  1
    $self add Mode54Mb   256  6.0031  1
    $self add Mode54Mb   256  7.0023  1
    $self add Mode54Mb   256  8.0009  1
    $self add Mode54Mb   256  9  1
    $self add Mode54Mb   256  10.0037  1
    $self add Mode54Mb   256  11.0025  1
    $self add Mode54Mb   256  12.0004  1
    $self add Mode54Mb   256  13.0009  1
    $self add Mode54Mb   256  14.0018  1
    $self add Mode54Mb   256  14.9989  0.9799
    $self add Mode54Mb   256  16.002  0.8254
    $self add Mode54Mb   256  17.0008  0.5589
    $self add Mode54Mb   256  18.0047  0.3298
    $self add Mode54Mb   256  19.0028  0.183
    $self add Mode54Mb   256  20.001  0.0976
    $self add Mode54Mb   256  21.0016  0.0575
    $self add Mode54Mb   256  22.0025  0.0316
    $self add Mode54Mb   256  23.003  0.0147
    $self add Mode54Mb   256  24.003  0.009
    $self add Mode54Mb   256  25.0049  0.005
    $self add Mode54Mb   256  26.0036  0.0023
    $self add Mode54Mb   256  27.0026  0.001
    $self add Mode54Mb   256  28.0026  0.0005
    $self add Mode54Mb   256  29.0014  0.0003
    $self add Mode54Mb   256  30.0004  0
    $self add Mode54Mb   512  0.0014733  1
    $self add Mode54Mb   512  1.0007  1
    $self add Mode54Mb   512  2.0015  1
    $self add Mode54Mb   512  3.0004  1
    $self add Mode54Mb   512  4.0005  1
    $self add Mode54Mb   512  5.0016  1
    $self add Mode54Mb   512  6.0007  1
    $self add Mode54Mb   512  6.9999  1
    $self add Mode54Mb   512  8.0014  1
    $self add Mode54Mb   512  9.0011  1
    $self add Mode54Mb   512  9.9994  1
    $self add Mode54Mb   512  11.0013  1
    $self add Mode54Mb   512  12.0037  1
    $self add Mode54Mb   512  13.0013  1
    $self add Mode54Mb   512  14.0012  1
    $self add Mode54Mb   512  15.0021  0.9986
    $self add Mode54Mb   512  16.0017  0.929
    $self add Mode54Mb   512  16.9998  0.7031
    $self add Mode54Mb   512  18.0007  0.4492
    $self add Mode54Mb   512  19.0009  0.2579
    $self add Mode54Mb   512  20.0016  0.1441
    $self add Mode54Mb   512  21  0.0749
    $self add Mode54Mb   512  21.9997  0.0395
    $self add Mode54Mb   512  22.9994  0.0193
    $self add Mode54Mb   512  24.0013  0.0105
    $self add Mode54Mb   512  25.0002  0.0045
    $self add Mode54Mb   512  26.0006  0.0033
    $self add Mode54Mb   512  27.0021  0.0016
    $self add Mode54Mb   512  28.0029  0.0009
    $self add Mode54Mb   512  29.0009  0.0001
    $self add Mode54Mb   512  30.0025  0.0001
    $self add Mode54Mb   1024  0.00096149  1
    $self add Mode54Mb   1024  0.99952  1
    $self add Mode54Mb   1024  2.0006  1
    $self add Mode54Mb   1024  3.0008  1
    $self add Mode54Mb   1024  4.0011  1
    $self add Mode54Mb   1024  5.0016  1
    $self add Mode54Mb   1024  5.9992  1
    $self add Mode54Mb   1024  7.0006  1
    $self add Mode54Mb   1024  8.0014  1
    $self add Mode54Mb   1024  8.9994  1
    $self add Mode54Mb   1024  10  1
    $self add Mode54Mb   1024  11.0014  1
    $self add Mode54Mb   1024  12.0002  1
    $self add Mode54Mb   1024  13.0012  1
    $self add Mode54Mb   1024  13.9996  1
    $self add Mode54Mb   1024  14.9997  1
    $self add Mode54Mb   1024  16.001  0.9789
    $self add Mode54Mb   1024  17.0006  0.815
    $self add Mode54Mb   1024  18.0009  0.5619
    $self add Mode54Mb   1024  19.0004  0.3393
    $self add Mode54Mb   1024  20.0009  0.1935
    $self add Mode54Mb   1024  21.0006  0.1055
    $self add Mode54Mb   1024  22.0008  0.0564
    $self add Mode54Mb   1024  23.0017  0.0302
    $self add Mode54Mb   1024  23.9999  0.0164
    $self add Mode54Mb   1024  25  0.0089
    $self add Mode54Mb   1024  26.0008  0.0049
    $self add Mode54Mb   1024  27.0003  0.0032
    $self add Mode54Mb   1024  28.0004  0.0011
    $self add Mode54Mb   1024  29.001  0.0006
    $self add Mode54Mb   1024  30.0012  0.0003
    $self add Mode54Mb   1500  0.00064928  1
    $self add Mode54Mb   1500  0.99996  1
    $self add Mode54Mb   1500  1.9999  1
    $self add Mode54Mb   1500  3.0004  1
    $self add Mode54Mb   1500  4.0015  1
    $self add Mode54Mb   1500  5.0015  1
    $self add Mode54Mb   1500  5.999  1
    $self add Mode54Mb   1500  7  1
    $self add Mode54Mb   1500  8.0013  1
    $self add Mode54Mb   1500  9.0008  1
    $self add Mode54Mb   1500  10.0002  1
    $self add Mode54Mb   1500  11.0002  1
    $self add Mode54Mb   1500  12.0014  1
    $self add Mode54Mb   1500  13.0011  1
    $self add Mode54Mb   1500  14.001  1
    $self add Mode54Mb   1500  15.0002  1
    $self add Mode54Mb   1500  16.0009  0.9858
    $self add Mode54Mb   1500  17.0009  0.8543
    $self add Mode54Mb   1500  18.0004  0.6068
    $self add Mode54Mb   1500  18.9993  0.3774
    $self add Mode54Mb   1500  20.0006  0.2207
    $self add Mode54Mb   1500  21.0008  0.1317
    $self add Mode54Mb   1500  22.001  0.0691
    $self add Mode54Mb   1500  22.9997  0.0376
    $self add Mode54Mb   1500  24.0001  0.0203
    $self add Mode54Mb   1500  25.0009  0.0108
    $self add Mode54Mb   1500  25.9994  0.0062
    $self add Mode54Mb   1500  27.0009  0.0029
    $self add Mode54Mb   1500  28.001  0.0013
    $self add Mode54Mb   1500  29.0001  0.0007
    $self add Mode54Mb   1500  29.9997  0.0004

}
