/*
Copyright (c) 1997, 1998 Carnegie Mellon University.  All Rights
Reserved. 

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice,
this list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright notice,
this list of conditions and the following disclaimer in the documentation
and/or other materials provided with the distribution.
3. The name of the author may not be used to endorse or promote products
derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

The WCETT code developed by the CMU/MONARCH group was optimized and tuned by Samir Das and Mahesh Marina, University of Cincinnati. The work was partially done in Sun Microsystems.
*/


#ifndef __wcett_packet_h__
#define __wcett_packet_h__

//#include <config.h>
//#include "wcett.h"
#define WCETT_MAX_ERRORS 100


/* =====================================================================
   Packet Formats...
   ===================================================================== */
#define WCETTTYPE_HELLO  	0x01
#define WCETTTYPE_RREQ   	0x02
#define WCETTTYPE_RREP   	0x04
#define WCETTTYPE_RERR   	0x08
#define WCETTTYPE_RREP_ACK  	0x10
#define WCETTTYPE_HELLO_ACK      0X12 //carmen  hello ack


/*
 * WCETT Routing Protocol Header Macros
 */
#define HDR_WCETT(p)		((struct hdr_wcett*)hdr_wcett::access(p))
#define HDR_WCETT_REQUEST(p)  	((struct hdr_wcett_request*)hdr_wcett::access(p))
#define HDR_WCETT_REPLY(p)	((struct hdr_wcett_reply*)hdr_wcett::access(p))
#define HDR_WCETT_ERROR(p)	((struct hdr_wcett_error*)hdr_wcett::access(p))
#define HDR_WCETT_RREP_ACK(p)	((struct hdr_wcett_rrep_ack*)hdr_wcett::access(p))

/*
 * General WCETT Header - shared by all formats
 */
struct hdr_wcett {
        u_int8_t        ah_type;
	/*
        u_int8_t        ah_reserved[2];
        u_int8_t        ah_hopcount;
	*/
		// Header access methods
	static int offset_; // required by PacketHeaderManager
	inline static int& offset() { return offset_; }
	inline static hdr_wcett* access(const Packet* p) {
		return (hdr_wcett*) p->access(offset_);
	}
};

struct ETTInfo {
        int nodeid;
        //since each route table may need to store multi route entry for each node
        //this index is to record which index to use.
        //int routetableindex; 
        int channel;
        int ETT;


};
        

struct hdr_wcett_request {
        u_int8_t        rq_type;	// Packet Type
        //u_int8_t        reserved[2];  //carmen
        u_int8_t        reserved[1];  //carmen
        u_int8_t        routeindex;
        //u_int8_t        channelnum; //record current link used which channel
        //u_int8_t        rq_ett;   // Hop Count//ETT for each link carmen
        u_int8_t        rq_hop_count;   // Hop Count
        u_int32_t       rq_bcast_id;    // Broadcast ID

        nsaddr_t        rq_dst;         // Destination IP Address
        u_int32_t       rq_dst_seqno;   // Destination Sequence Number
        nsaddr_t        rq_src;         // Source IP Address
        u_int32_t       rq_src_seqno;   // Source Sequence Number

        double          rq_timestamp;   // when REQUEST sent;
					// used to compute route discovery latency
        ETTInfo         RouteRecord[20];     

  // This define turns on gratuitous replies- see wcett.cc for implementation contributed by
  // Anant Utgikar, 09/16/02.
  //#define RREQ_GRAT_RREP	0x80


  inline int size() { 
  int sz = 0;
  /*
  	sz = sizeof(u_int8_t)		// rq_type
	     + 2*sizeof(u_int8_t) 	// reserved
	     + sizeof(u_int8_t)		// rq_hop_count
	     + sizeof(double)		// rq_timestamp
	     + sizeof(u_int32_t)	// rq_bcast_id
	     + sizeof(nsaddr_t)		// rq_dst
	     + sizeof(u_int32_t)	// rq_dst_seqno
	     + sizeof(nsaddr_t)		// rq_src
	     + sizeof(u_int32_t);	// rq_src_seqno
  */
  	sz = 7*sizeof(u_int32_t);
        sz=20*sizeof(ETTInfo)+sz;
  	assert (sz >= 0);
	return sz;
  }
};

struct hdr_wcett_reply {
        u_int8_t        rp_type;        // Packet Type
       // u_int8_t        reserved[2];  //carmen
        //u_int8_t        reserved[1]; 
        u_int8_t        channelnum; //record current link used which channel
        u_int8_t        rq_ett;   // Hop Count//ETT for each link carmen
        u_int8_t        rp_hop_count;           // Hop Count
        nsaddr_t        rp_dst;                 // Destination IP Address
        u_int32_t       rp_dst_seqno;           // Destination Sequence Number
        nsaddr_t        rp_src;                 // Source IP Address
        double	        rp_lifetime;            // Lifetime

        double          rp_timestamp;           // when corresponding REQ sent;
						// used to compute route discovery latency
        ETTInfo         RouteRecord[20];   
						
  inline int size() { 
  int sz = 0;
  /*
  	sz = sizeof(u_int8_t)		// rp_type
	     + 2*sizeof(u_int8_t) 	// rp_flags + reserved
	     + sizeof(u_int8_t)		// rp_hop_count
	     + sizeof(double)		// rp_timestamp
	     + sizeof(nsaddr_t)		// rp_dst
	     + sizeof(u_int32_t)	// rp_dst_seqno
	     + sizeof(nsaddr_t)		// rp_src
	     + sizeof(u_int32_t);	// rp_lifetime
  */
  	sz = 6*sizeof(u_int32_t);
        sz=20*sizeof(ETTInfo)+sz;
  	assert (sz >= 0);
	return sz;
  }

};

struct hdr_wcett_error {
        u_int8_t        re_type;                // Type
        u_int8_t        reserved[2];            // Reserved
        u_int8_t        DestCount;                 // DestCount
        // List of Unreachable destination IP addresses and sequence numbers
        nsaddr_t        unreachable_dst[WCETT_MAX_ERRORS];   
        u_int32_t       unreachable_dst_seqno[WCETT_MAX_ERRORS];   

  inline int size() { 
  int sz = 0;
  /*
  	sz = sizeof(u_int8_t)		// type
	     + 2*sizeof(u_int8_t) 	// reserved
	     + sizeof(u_int8_t)		// length
	     + length*sizeof(nsaddr_t); // unreachable destinations
  */
  	sz = (DestCount*2 + 1)*sizeof(u_int32_t);
	assert(sz);
        return sz;
  }

};

struct hdr_wcett_rrep_ack {
	u_int8_t	rpack_type;
	u_int8_t	reserved;
        double           RxPr;
  inline int size() { 
  int sz = 0;
  /*
  	sz = sizeof(u_int8_t)		// type
	     + 2*sizeof(u_int8_t) 	// reserved
	     + sizeof(u_int8_t)		// length
	     + length*sizeof(nsaddr_t); // unreachable destinations
  */
  	sz = 2*sizeof(u_int8_t)+
             sizeof(float);	

	assert(sz);
        return sz;
  }

};

/*
//carmen ack for hello
struct hdr_wcett_hello_ack {
	u_int8_t	rpack_type;
	u_int8_t	reserved;
        float           RxPr;

};
*/


// for size calculation of header-space reservation
union hdr_all_wcett {
  hdr_wcett          ah;
  hdr_wcett_request  rreq;
  hdr_wcett_reply    rrep;
  hdr_wcett_error    rerr;
  hdr_wcett_rrep_ack rrep_ack;
};








#endif /* __wcett_packet_h__ */
