#import "AppDelegate.h"

@implementation AppDelegate

- (BOOL)application:(UIApplication *)application didFinishLaunchingWithOptions:(NSDictionary *)launchOptions
{
    // The FizzBuzz Problem
    // Write a program that iterates over the numbers 1-100. If the number is divisible by 3
    // print Fizz, if the number is divisible by 5 print Buzz. If the number is divisible by
    // both 5 and 3 print FizzBuzz. Otherwise just print the number.
    
    
    // The first thing we want to do is to list the numbers 1-100
    // To do this we start the counter at 1
    // We then iterate over the loop while counter is less than or equal to 100
    // This means that as soon as counter reaches 101 it will stop
    // We use the '++' operator to increment counter by 1
    // This is another way of writing 'counter = counter + 1'
    for (int counter=1; counter<=100; counter++) {
        
        // Below we are using the 'if - else if' control flow to test if something is true
        // If it is not true then it will test the next 'else if' statement
        
        
        // Here we are testing if the current number is divisible by 3 and divisible by 5
        // See below for a description of how to check if a number is divisible by 3 or 5
        // We use the '&&' operator to make sure that the number is divisible by both 3 AND 5
        if ( ((counter % 3) == 0) && ((counter % 5) == 0)) {
            // Logging FIZZBUZZ to the console
            NSLog(@"FIZZBUZZ"); 
        }
        
        // Here we are testing to see if the current number is divisible by 3
        // To do this we are using the modulo '%' operator which gives us a remander of two numbers
        // For instance 5 % 3 would give us 2 (since 5/3 = 1r2)
        // For a number to be divisible by 3 it has to have a remainder of 0 when divided by 3
        // So once we find the mod of the current number divided by 3 we test if it is equal to 0
        else if ( (counter % 3) == 0 ) {
            // Logging FIZZ to the console
            NSLog(@"FIZZ");
        }
        
        // Here we are testing to see if the current number is divisible by 5
        // To do this we are using the modulo '%' operator which gives us a remander of two numbers
        // For instance 5 % 3 would give us 2 (since 5/3 = 1r2)
        // For a number to be divisible by 5 it has to have a remainder of 0 when divided by 5
        // So once we find the mod of the current number divided by 5 we test if it is equal to 0
        else if ( (counter % 5) == 0 ) {
            // Logging BUZZ to the console
            NSLog(@"BUZZ");
        }
        
        // Finally if none of the above is true we just print out the number
        else {
            // Printing out the numbers
            NSLog(@"%d",counter);
        }
    }
    
    self.window = [[UIWindow alloc] initWithFrame:[[UIScreen mainScreen] bounds]];
    self.window.backgroundColor = [UIColor whiteColor];
    [self.window makeKeyAndVisible];
    return YES;
}

@end
