//
//  DetailViewController.m
//  Catalogue
//
//  Created by kcfancher on 8/6/12.
//  Copyright (c) 2012 kcfancher. All rights reserved.
//

#import "DetailViewController.h"
#import "CD.h"
#import "Book.h"

@interface DetailViewController ()

@end

@implementation DetailViewController
@synthesize addImageButton;
@synthesize nameLabel;
@synthesize creatorLabel;
@synthesize priceLabel;
@synthesize idLabel;
@synthesize item = _item;
@synthesize imageView;
@synthesize imagePicker = _imagePicker;
// Initialize the labels with the values for the item that we have been assigned
- (void)viewDidLoad
{
    [super viewDidLoad];
	// Do any additional setup after loading the view.
    
    self.priceLabel.text = [NSString stringWithFormat:@"$%.2f",self.item.price];
    self.idLabel.text = [NSString stringWithFormat:@"%d",self.item.identificationNumber];
    
    if ([self.item isMemberOfClass:[Book class]]) {
        self.addImageButton.hidden = NO;
        Book *book = (Book *)self.item;
        self.nameLabel.text = book.title;
        self.creatorLabel.text = book.author;
    } else if ([self.item isMemberOfClass:[CD class]]) {
        self.addImageButton.hidden = YES;
        CD *cd = (CD *)self.item;
        self.nameLabel.text = cd.label;
        self.creatorLabel.text = cd.artist;
    }
    
    // We initialize the picker and set the delegate to self
    // This means that we have to implement the UINavigationControllerDelegate
    // and UIImagePickerControllerDelegate protocols
    // We then set the sourceType to UIImagePickerControlleSourceTypeCamera to
    // show that we are using the camera, we can also use UIImagePickerControlleSourceTypePhotoLibrary
    self.imagePicker = [[UIImagePickerController alloc] init];
    self.imagePicker.delegate = self;
    self.imagePicker.sourceType = UIImagePickerControllerSourceTypePhotoLibrary;
}

- (void)viewDidUnload
{
    [self setNameLabel:nil];
    [self setCreatorLabel:nil];
    [self setPriceLabel:nil];
    [self setIdLabel:nil];
    [self setImageView:nil];
    [self setAddImageButton:nil];
    [super viewDidUnload];
    // Release any retained subviews of the main view.
}

- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)interfaceOrientation
{
    return (interfaceOrientation == UIInterfaceOrientationPortrait);
}

// Our action method to respond to the add button being pressed
- (IBAction)addImage:(UIButton *)sender {
    // Display the image picker
    [self presentModalViewController:self.imagePicker animated:YES];
}

// The UIImagePickerControllerDelegate method that is called when the user
// finalizes their photo selection
- (void)imagePickerController:(UIImagePickerController *)picker didFinishPickingMediaWithInfo:(NSDictionary *)info
{
    // Grab the unedited image out of the image dictionary
    UIImage *newImage = [info objectForKey:UIImagePickerControllerOriginalImage];
    // Cast the item to a book
    Book *book = (Book *)self.item;
    // Set the book's image to the newItem
    book.image = newImage;
    // Set the displays image to the image
    self.imageView.image = book.image;
    // dismiss the image picker
    [self dismissModalViewControllerAnimated:YES];
}

@end
