//
//  CalculatorViewController.m
//  Calculator
//
//  Created by kcfancher on 8/2/12.
//  Copyright (c) 2012 kcfancher. All rights reserved.
//

#import "CalculatorViewController.h"

@implementation CalculatorViewController
@synthesize display;
@synthesize typingNumber = _typingNumber;
@synthesize model = _model;

// - (void)viewDidLoad is called after iOS loads the view but before it is displayed
// It is commonly used to instantiate (set the default values) for instance variables
- (void)viewDidLoad
{
    [super viewDidLoad];
	
    // When the view is loaded the user is not currently typing a number
    self.typingNumber = NO;
    // We need to instantiate model with a new CalculatorModel
    self.model = [[CalculatorModel alloc] init];
}

// This is the method that is caled whenever a user clicks on a digit
- (IBAction)numberPressed:(UIButton *)sender {
    // If the typing number variable is YES
    if (self.typingNumber) {
        // If we are typing a number we append the title of the button to the current display
        // The reason for this is that we are already in the middle of typing a series of
        // numbers and we just want to append the next number
        NSString *newDisplay = [self.display.text stringByAppendingFormat:@"%@",sender.titleLabel.text];
        self.display.text = newDisplay;
    }
    // Otherwise if the typing number variable is NO
    else {
        // In this case we are not already tying so we just replace the current text field with
        // the buttons title
        self.display.text = sender.titleLabel.text;
        // We also set self.typingNumeber to YES so that next time we can append the number
        // instead of replacing the current text
        self.typingNumber = YES;
    }
}

// This is the method that is caled whenever a user clicks on an operator
- (IBAction)operationPressed:(UIButton *)sender {
    
    // We create a NSString instance variable called operator that is
    // the value of the pressed buttons text (sender.titleLabel.text)
    NSString *operator = sender.titleLabel.text;
    
    // We are testing to see if we are currently typing a number
    // since we do not want to respond to an operator twice in a row
    if (self.typingNumber) {
        
        // We use an NSString instance method '- (double)doubleValue' to
        // convert the string into a double
        double currentNumber = [self.display.text doubleValue];
        
        // Next we test to see if the operator is an '=' sign
        // If it is we want to do the calculation
        if ([operator isEqualToString:@"="]) {
            // Setting the value returned by our model's calculation to the result instance variable
            double result = [self.model performOperationWithOperand:currentNumber];
            NSLog(@"Result %f", result); // Logging the result to show that it worked
        }
        // Otherwise if it is not an equal sign we are going to store
        // the operation and operand within our model instance variable
        else {
            // Setting our model's waitingOperand to the number that is currently in the display
            self.model.waitingOperand = currentNumber;
            // Setting our model's operation to the operator that was just pressed
            self.model.operation = operator;
        }
        
        // We just pressed an operation which means the next numbers that we type
        // should replace the current display with new text
        self.typingNumber = NO;
    }
}

- (void)viewDidUnload
{
    [self setDisplay:nil];
    [super viewDidUnload];
}

- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)interfaceOrientation
{
    return (interfaceOrientation != UIInterfaceOrientationPortraitUpsideDown);
}
@end
