//
//  CalculatorViewController.h
//  Calculator
//
//  Created by kcfancher on 8/2/12.
//  Copyright (c) 2012 kcfancher. All rights reserved.
//

#import <UIKit/UIKit.h>
#import "CalculatorModel.h"

@interface CalculatorViewController : UIViewController

// The Outlet connecting to our calculators display in our interface
@property (weak, nonatomic) IBOutlet UILabel *display;
// A BOOL variable to keep track if a user is currently typing a number
@property (nonatomic) BOOL typingNumber;
// A instance variable pointing to our Model class
@property (nonatomic, strong) CalculatorModel *model;

// An action method that will be called whenever a digit is pressed
- (IBAction)numberPressed:(UIButton *)sender;
// An action method that will be called whenever an operation is pressed
- (IBAction)operationPressed:(UIButton *)sender;

@end
