//
//  CalculatorModel.h
//  Calculator
//
//  Created by kcfancher on 8/2/12.
//  Copyright (c) 2012 kcfancher. All rights reserved.
//

#import <Foundation/Foundation.h>

// This class is our Calculators Model
// Keep in mind that the model in MVC is responsible
// for keeping track of data - and performing logical calculations
// We can also think of the model as the Brain or Engine of the app

@interface CalculatorModel : NSObject

// A double that we will use to store the waitingOperand
// this is the first value 'X' in our operation X * Y = Z
@property (nonatomic) double waitingOperand;

// A NSString object to store the operation
// this is the '*' value in our operation X * Y = Z
@property (nonatomic, strong) NSString *operation;

// A method to perform the final calculation and return the result
- (double)performOperationWithOperand:(double)newOperand;

@end
